ORCA/M Asm65816 2.1.0

0001 7016                       title 'QD Patch        GS ROM 3 Patch' 
0002 7016              ******************************************************************
0003 7016              *
0004 7016              * QD patches for ROM 3
0005 7016              *
0006 7016              * Copyright 1989-1992 Apple Computer, Inc.
0007 7016              * All Rights Reserved
0008 7016              *
0009 7016              ******************************************************************
0010 7016              *
0011 7016              * System Disk 5.0
0012 7016              *
0013 7016              * 5/18/89           Steven Glass
0014 7016              *
0015 7016              * 31 May 89         Harry Yee
0016 7016              *
0017 7016              * Take prototype bit out of version number. Final version = 3.1  
0018 7016              * for System Disk 5.0.
0019 7016              *
0020 7016              * 03/06/90          Harry Yee
0021 7016              *
0022 7016              * Patching SetForeColor to patch the Menu Manager. This patch adds
0023 7016              * icon support for menu items. All we are doing is patching the return
0024 7016              * address for the call if SetForeColor is being called by the Menu
0025 7016              * Manager at the place we want to patch out.
0026 7016              *
0027 7016              * 4/4/90            Mensch
0028 7016              *
0029 7016              * Patched the 4 rgnOp routines so that they will properly unlock the
0030 7016              * right region handles. OOOOps, guess I also speeded them up just a little
0031 7016              * sorry for that...
0032 7016              *
0033 7016              * 17-Sep-90         Dave Lyons
0034 7016              *
0035 7016              * Harry's FinishSetForeColor and FinishPtInRect pathces had been
0036 7016              * commented out.  I'm putting them back in for 6.0, since some other
0037 7016              * files are referencing them & preventing me from building TS3.
0038 7016              *
0039 7016              * 24-Sep-90         Dave Lyons
0040 7016              *
0041 7016              * Version $8306.
0042 7016              * Adding Get640Colors and Set640Color.
0043 7016              *
0044 7016              * 22-Oct-90         Dave Lyons
0045 7016              *
0046 7016              * Adding $DC04 GetScanlineAddr.
0047 7016              * Put all.macros back in.
0048 7016              *
0049 7016              * 24-Nov-90         Dave Lyons
0050 7016              *
0051 7016              * Patched QDStartUp to call FixHandle2 (stolen from TS2 Cursor.Patch.asm)
0052 7016              * to make the cursor images handle not cross a bank boundary.
0053 7016              *
0054 7016              * 25-Nov-90         Dave Lyons
0055 7016              *
0056 7016              * Changed version number to $8307, since 5.0.4 is going to be $0306.
0057 7016              *
0058 7016              * 25-Nov-90         Dave Lyons
0059 7016              *
0060 7016              * Changed QDStartUp to set DontClearScrnFlag if MasterSCB bit $0100
0061 7016              * is on and the SHR screen is already being displayed.
0062 7016              * Changed ClearScreen not to clear the screen if DontClearScrnFlag
0063 7016              * is set.
0064 7016              *
0065 7016              * 14-Feb-91         Dave Lyons
0066 7016              *
0067 7016              * Removed GetScanlineAddr because it isn't useful enough.
0068 7016              *
0069 7016              * 18-Feb-91         Dave Lyons
0070 7016              *
0071 7016              * Re-enabled Mensch's MySetCursor patch (had been commented out
0072 7016              * for 5.0.3 and 5.0.4).
0073 7016              *
0074 7016              * 19-Feb-91         Dave Lyons
0075 7016              *
0076 7016              * Fixed the ClearScreen patch to jump to ROM with the correct
0077 7016              * WAP value in A, instead of $0000.  Oops.
0078 7016              *
0079 7016              * 25-Feb-91         Dave Lyons
0080 7016              *
0081 7016              * QDStartUp now deletes Message #6 (the mouse position message)
0082 7016              * from the MessageCenter if the screen was off.  It only makes
0083 7016              * sense to preserve the mouse position on a true smooth launch.
0084 7016              *
0085 7016              * 11-Mar-91         Dave Lyons
0086 7016              *
0087 7016              * Removed MySetCursor patch.
0088 7016              *
0089 7016              * 7-Apr-91          Dave Lyons
0090 7016              *
0091 7016              * QDShutDown now shuts down QDAux first if it's started up (this
0092 7016              * is necessary because Standard File now starts up QD Aux).
0093 7016              *
0094 7016              * 5-Aug-91          Dave Lyons
0095 7016              *
0096 7016              * Resurrected SetCursor patch again.  This time it looks at bit
0097 7016              * 31 of the new cursor pointer; if set, it doesn't undraw the
0098 7016              * old cursor.
0099 7016              *
0100 7016              * 26-Aug-91         Dave Lyons
0101 7016              *
0102 7016              * QDStartUp leaves the MasterSCB $0100 (smooth launch) bit set
0103 7016              * until the call is done, so that CloseView can see the bit
0104 7016              * during its ClearScreen patch.
0105 7016              *
0106 7016              * 6-Sep-91          Dave Lyons
0107 7016              *
0108 7016              * QDShutDown now turns off linearization ($C029 bit 6) even
0109 7016              * if it leaves the SHR screen on.  It's evil to leave linear
0110 7016              * on, because it screws up double-hires!
0111 7016              *
0112 7016              * 19-Nov-91         Dave Lyons
0113 7016              *
0114 7016              * QDShutDown sets master SCB to $0080, inits color table zero,
0115 7016              * and sets all SCBs to $0080.
0116 7016              *
0117 7016              * QDStartUp checks bit 2 of BRAM $5F --> don't use scanline
0118 7016              * interrupts (for better compatibility with accelerators and
0119 7016              * VOCs).
0120 7016              *
0121 7016              * 27-Nov-91         Dave Lyons
0122 7016              *
0123 7016              * Patched InflateTextBuffer to return errors.
0124 7016              *
0125 7016              * 3-Dec-91          Dave Lyons
0126 7016              *
0127 7016              * Finished fixing above--on failure, it needs to restore a few direct page
0128 7016              * locations, so we don't think the buffer has been inflated when it hasn't.
0129 7016              * (Since QuickDraw Aux chains in *after* the main QD buffer-resize routines,
0130 7016              * QD already decided it was okay to store the new buffer size values when
0131 7016              * QD Aux found it could not resize its buffers, so we have to undo the damage.)
0132 7016              *
0133 7016              * 3-Feb-92          Dave Lyons
0134 7016              *
0135 7016              * Fixed QDStartUp patch to destroy message $0023 (FastFont message) if we
0136 7016              * fail to get FastFont.  Sometimes a stale message was left around and we
0137 7016              * tried to use somebody else's handle for FastFont (the system does not
0138 7016              * live very long in that state).
0139 7016              *
0140 7016              * Optimized error-exit for QDStartUp.
0141 7016              *
0142 7016              * Fixed QDStartUp to copy the E1 screen down to the 01 screen if
0143 7016              * we got shadowing.
0144 7016              *
0145 7016              * 5-Feb-92          Dave Lyons
0146 7016              *
0147 7016              * Version $0307 for 6.0 final.
0148 7016              *
0149 7016              ******************************************************************
0150 7016              *
0151 7016              * 17-Feb-92         Dave Lyons
0152 7016              *
0153 7016              * Version $8308 for 6.0.1d1.
0154 7016              *
0155 7016              * 2-Apr-93 DAL
0156 7016              *
0157 7016              * Version $0308 for 6.0.1.
0158 7016              *
0159 7016              ******************************************************************
0160 7016                       Blanks off 
0161 7016                       String asis 
0162 7016
0163 7016                       include 'all.macros' 
0164 7016
0165 7016                       include ':::qd:qdequates:qd.data.asm' 
0166 7016                       INCLUDE ':::qd:QDEquates:CORE.GLOBALS1' 
0167 7016                       INCLUDE ':::qd:QDEquates:core.globals2' 
0168 7016                       INCLUDE ':::qd:QDEquates:region.equs' 
0169 7016                       INCLUDE ':::qd:QDEquates:RECT.EQUS' 
0170 7016                       INCLUDE ':::qd:QDEquates:SLAB.EQUS' 
0171 7016                       INCLUDE ':::qd:QDEquates:rgndefs.equs' 
0172 7016
0173 7016                       include 'e16.memory' 
0174 7016                       Import iDrawCursor 
0175 7016                       Import iunDrawCursor 
0176 7016                       Entry DoRgnOp 
0177 7016
0178 7016              *******************************************************************************
0179 7016              ;
0180 7016              ; Following are all ROM addresses needed by this file
0181 7016              ;
0182 7016              QDStart  equ   $FE0FAA
0183 7016              RgnBEmpty equ   $FE75FE
0184 7016              RgnAEmpty equ   $FE75E7
0185 7016              RgnSector equ   $FE7615
0186 7016              TheROMRTL equ   $FE0125                 ; address of an RTL in ROM 1
0187 7016              BusyErr12 equ   $FEFC74
0188 7016              BusyEC12 equ   $FEFC71
0189 7016              ROMNotEasy equ   $FE7766
0190 7016              BusyFlag equ   $E100FF
0191 7016
0192 7016              SlabCopy equ   $00FE24D0
0193 7016              SLABOR   equ   $00FE2568
0194 7016              SLABXOR  equ   $00FE25F6
0195 7016              SLABBIC  equ   $00FE2684
0196 7016
0197 7016
0198 7016              FASTSLABXOR equ   $00FE2721
0199 7016              FASTSLABCOPY equ   $00FE2A26
0200 7016              FASTSLABOR equ   $00FE2C90
0201 7016              FASTSLABBIC equ   $00FE2D09
0202 7016
0203 7016              GOREALLYFASTXOR EQU $FE2796 
0204 7016              FastSlabXorAlt equ   $FE2742
0205 7016              GOREALLYFASTCOPY EQU $FE2A9F 
0206 7016              FastSlabCopyAlt equ   $FE2A47
0207 7016
0208 7016              ROMFastBigLoop equ   $FE9171
0209 7016              ROMSlowBigLoop equ   $FE9233
0210 7016              ROMSetStuffAdr equ   $FE92E0
0211 7016              ROMConTable320 equ   $FE6372
0212 7016              ROMConTable640 equ   $FE6772
0213 7016
0214 7016                       import iSetStuffAdr 
0215 7016                       import iBlowItUp 
0216 7016
0217 7016              ***	import DoADirtyDeed	; from FontMgr.Pch
0218 7016
0219 7016              ** re-enabled these 2 lines 17-Sep-90 DAL
0220 7016                       import DoADirtyDeed2           ; from MenuMgr.Pch
0221 7016                       import DoADirtyDeed3           ; from MenuMgr.Pch
0222 7016
0223 7016                       EJECT 
0224 7016              *******************************************************************************
0225 7016              *
0226 7016              MyStartup PROC Export 
0227 7016              *
0228 7016              * Description:      This routine will post patch qdstartup so we can get rid of the
0229 7016              *                   fastfont if needed...
0230 7016              *
0231 7016              *
0232 7016              * Inputs:           same as QDStartup.
0233 7016              *
0234 7016              * Outputs:          None
0235 7016              *
0236 7016              *******************************************************************************
0237 7016              ROMQDStartup equ   $FE0BB5
0238 7016              SystemFont equ   $FCDD1B
0239 7016                       Export AnRTL 
0240 7016
0241 7016              OrigDirect equ   1
0242 7016              RTL1     equ   OrigDirect+2
0243 7016              RTL2     equ   RTL1+3
0244 7016              TheUserID equ   RTL2+3
0245 7016              TheMaxWidth equ   TheUserID+2
0246 7016              TheMasterSCB equ   TheMaxWidth+2
0247 7016              PtrToZP  equ   TheMasterSCB+2
0248 7016
0249 7016              ; New MasterSCB Equates we can use
0250 7016              UseShadow equ   $8000
0251 7016              HiddenSpeed equ   $4000
0252 7016              ***Avail1	equ	$2000
0253 7016              NoFastFont equ   $1000
0254 7016              dontKillScreen equ   $0100              ;25-Nov-90 DAL: Keep screen intact if already on
0255 7016
0256 7016                       import DontClearScrnFlag       ;from ClearScreen patch
0257 7016
0258 7016 AA                    tax                            ;save old WAP (24-Nov-90 DAL)
0259 7017 0B                    phd                            ; save the dpage from harm
0260 7018 3B                    tsc   
0261 7019 5B                    tcd   
0262 701A
0263 701A              ***	lda	TheMasterSCB
0264 701A              ***	and	#NoFastFont
0265 701A              ***	bne	@MustFudgeFastFont
0266 701A              ***	tdc	; added 24-Nov-90 DAL so we get alreadyStarted error
0267 701A              ***	pld	; recover old user dpage 
0268 701A              ***	jml	>ROMQDStartup	; and simply jump into ROM
0269 701A              ***
0270 701A              *** @MustFudgeFastFont
0271 701A              *** ; If we get here then the programmer set bit saying not to load fast font
0272 701A              *** ; and we better call qdstartup and then unload the thing...
0273 701A
0274 701A              *** added 25-Nov-90 DAL to avoid clearing screen if we can
0275 701A A5 0D                 lda   <TheMasterSCB
0276 701C 29 00 01              and   #dontKillScreen
0277 701F 8F 9B 74 02           sta   >DontClearScrnFlag
0278 7023
0279 7023 AF 29 C0 E0           lda   >$E0C029
0280 7027 29 80 00              and   #$0080
0281 702A D0 15                 bne   @1
0282 702C 8F 9B 74 02           sta   >DontClearScrnFlag
0283 7030              *** added 25-Feb-91 DAL: If the screen was off, kill the Event Manager mouse pos message
0284 7030 DA                    phx   
0285 7031 F4 03 00              pea   3                        ;delete message
0286 7034 F4 06 00              pea   6                        ;message type
0287 7037 48                    pha   
0288 7038 48                    pha                            ;handle (ignored)
0289 7039 A2 01 15 22           _MessageCenter 
0290 7040 FA                    plx   
0291 7041              *** end of 25-Feb-91 DAL
0292 7041              @1        
0293 7041              ;;;	lda	#dontKillScreen	;removed 26-Aug-91 DAL
0294 7041              ;;;	trb <TheMasterSCB	;removed 26-Aug-91 DAL
0295 7041              *** end of 25-Nov-90 DAL
0296 7041
0297 7041 D4 0F                 pei   PtrToZP
0298 7043 D4 0D                 pei   TheMasterSCB
0299 7045 D4 0B                 pei   TheMaxWidth
0300 7047 D4 09                 pei   TheUserID
0301 7049              ***	lda	#0
0302 7049 8A                    txa                            ;retrieve old WAP (24-Nov-90 DAL)
0303 704A 22 2B 74 02           jsl   ROMStartupGlue           ; call the real startup routine
0304 704E 90 17                 bcc   @ItsOK
0305 7050
0306 7050 48                    pha                            ;25-Nov-90 DAL (4 lines)
0307 7051 A9 00 00              lda   #0
0308 7054 8F 9B 74 02           sta   >DontClearScrnFlag
0309 7058 68                    pla   
0310 7059
0311 7059 AA           @QDSTartError tax                       ; save the error code..
0312 705A              @UnZipThiscall  
0313 705A              ;	tsc
0314 705A              ;	tcd		; set up the proper dpage again...
0315 705A              ;	lda	RTL1+4	; move everything down by 8 bytes
0316 705A              ;	sta	RTL1+4+8
0317 705A              ;	lda	RTL1+2	; move everything down by 8 bytes
0318 705A              ;	sta	RTL1+2+8
0319 705A              ;	lda	RTL1	; move everything down by 8 bytes
0320 705A              ;	sta	RTL1+8
0321 705A              ;	pld		; restore the old dpage..
0322 705A              ;	pla		; yank off the 8 bytes of parameter
0323 705A              ;	pla
0324 705A              ;	pla
0325 705A              ;	pla
0326 705A              ;	txa		; recover any error code
0327 705A              ;	cmp	#1	; set the carry if error
0328 705A              ;	rtl		; and return
0329 705A              *** opt 3-Feb-92 DAL -- save bytes by using ToStrip
0330 705A 2B                    pld   
0331 705B A0 08 00              ldy   #8
0332 705E 5C 84 01 E1           jml   $e10184                  ;ToStrip
0333 7062              *** end 3-Feb-92
0334 7062
0335 7062 A2 00 00     @CallDone ldx   #0
0336 7065 80 F3                 bra   @UnZipThisCall
0337 7067              ;
0338 7067              @ItsOK    
0339 7067              *** added 3-Feb-92 DAL -- kill the FastFont message if we no longer have FastFont
0340 7067 48                    pha   
0341 7068 48                    pha   
0342 7069 A2 04 B3 22           _GetSysFont 
0343 7070 68                    pla   
0344 7071 68                    pla   
0345 7072 30 0F                 bmi   @haveFF
0346 7074
0347 7074 F4 03 00              pea   3                        ;delete
0348 7077 F4 23 00              pea   $0023                    ;message type
0349 707A DA                    phx   
0350 707B DA                    phx                            ;ignored
0351 707C A2 01 15 22           _MessageCenter 
0352 7083              @haveFF   
0353 7083
0354 7083 48                    pha   
0355 7084 A2 04 17 22           _GetMasterSCB 
0356 708B 68                    pla   
0357 708C 10 18                 bpl   @noShadow
0358 708E
0359 708E              *** copy E1 screen down to 01 screen if we got shadowing
0360 708E A2 00 20              ldx   #$2000
0361 7091 F4 E1 00              pea   $00e1
0362 7094 DA                    phx                            ;src = $e1/2000
0363 7095 F4 01 00              pea   $0001
0364 7098 DA                    phx                            ;dest = $01/2000
0365 7099 F4 00 00              pea   0
0366 709C F4 00 7D              pea   $7d00
0367 709F A2 02 2B 22           _BlockMove 
0368 70A6              @noShadow  
0369 70A6              *** end 3-Feb-92
0370 70A6
0371 70A6              *** added 26-Aug-91 DAL -- clear MasterSCB $0100 here
0372 70A6 48                    pha   
0373 70A7 A2 04 17 22           _GetMasterSCB 
0374 70AE 68                    pla   
0375 70AF 29 FF FE              and   #$FEFF
0376 70B2 48                    pha   
0377 70B3 A2 04 16 22           _SetMasterSCB 
0378 70BA              *** end 26-Aug-91 DAL
0379 70BA
0380 70BA              *** 24-Nov-90 DAL: call FixHandle2 to make the cursor image handle safe
0381 70BA 0B                    phd   
0382 70BB A5 0F                 lda   <PtrToZP
0383 70BD 5B                    tcd   
0384 70BE 22 30 74 02           jsl   FixHandle2
0385 70C2 2B                    pld   
0386 70C3              *** end 24-Nov-90
0387 70C3
0388 70C3              *** added 19-Nov-91 DAL -- check BRAM to disable scanline interrupt use
0389 70C3 48                    pha   
0390 70C4 F4 5F 00              pea   $005F
0391 70C7 A2 03 0C 22           _ReadBParam 
0392 70CE 68                    pla   
0393 70CF 29 04 00              and   #$0004                   ;bit 2 = no scanline ints
0394 70D2 F0 0A                 beq   @normal
0395 70D4 F4 00 00              pea   0
0396 70D7 A2 04 B6 22           _SetIntUse 
0397 70DE              @normal   
0398 70DE              *** end 19-Nov-91
0399 70DE
0400 70DE A5 0D                 lda   <TheMasterSCB            ;added 24-Nov-90 DAL
0401 70E0 29 00 10              and   #NoFastFont              ;added 24-Nov-90 DAL
0402 70E3 F0 43                 beq   @toCallDone              ;added 24-Nov-90 DAL
0403 70E5
0404 70E5 A5 0F                 lda   PtrToZP                  ; use quickdraw's dpage here
0405 70E7 5B                    tcd   
0406 70E8 A2 00 02              ldx   #512                     ; first see if we have a fast font
0407 70EB B5 F0                 lda   FastROMFont,x
0408 70ED 15 F2                 ora   FastRomFont+2,x
0409 70EF F0 37                 beq   @toCallDone              ; if zero fast font not loaded
0410 70F1
0411 70F1 F4 02 00              pea   2                        ; now set the fastfont as purgable...
0412 70F4 B5 F2                 lda   FastROMFont+2,x
0413 70F6 29 FF 00              and   #$00FF                   ; strip any flag data
0414 70F9 48                    pha   
0415 70FA B5 F0                 lda   FastRomFont,x
0416 70FC 48                    pha   
0417 70FD A2 02 24 22           _SetPurge                      ; this way if by chance it is still needed...
0418 7104
0419 7104 A2 00 02              ldx   #512                     ; first see if we have a fast font
0420 7107 A9 00 00              lda   #0                       ; now signal that the fast rom font is not here
0421 710A 95 F0                 sta   FastROMFont,x
0422 710C 95 F2                 sta   FastRomFont+2,x
0423 710E
0424 710E              ; reset the current system font so that it does not think it's the fastfont.
0425 710E F4 FC 00              pea   $00FC
0426 7111 F4 1B DD              pea   $DD1B
0427 7114 F4 FC 00              pea   $00FC
0428 7117 F4 1B DD              pea   $DD1B
0429 711A A2 04 B2 22           _SetSysFont 
0430 7121 A2 04 94 22           _SetFont 
0431 7128 82 37 FF     @toCallDone brl   @CallDone             ; and end the call with no problems
0432 712B
0433 712B 22 B5 0B FE  ROMStartupGlue jsl   >ROMQDStartup
0434 712F 6B           AnRTL    rtl   
0435 7130
0436 7130
0437 7130              ***************************************************************
0438 7130              *
0439 7130              * FixHandle2: Stolen from Patch2:Cursor.patch.asm 24-Nov-90 DAL
0440 7130              *
0441 7130              ***************************************************************
0442 7130              *
0443 7130              * FixHandle
0444 7130              *
0445 7130              * Added to Patch 22 May 87
0446 7130              *
0447 7130              * The cursor save area is the area of the screen under the
0448 7130              * cursor.  It is put into a buffer just before the cursor
0449 7130              * is drawn.
0450 7130              *
0451 7130              * Unfortunately if the save buffer crosses a bank boundry,
0452 7130              * the code to write into does not work and ends up
0453 7130              * trashing bytes at the bottom of the bank the buffer
0454 7130              * starts in.
0455 7130              *
0456 7130              * This patch fixes the problem by working after the QDStartup
0457 7130              * call is complete.  It looks on the QD direct page for the
0458 7130              * handle to the save area and replaces it with a new handle
0459 7130              * having attributes which do not allow it to cross a bank.
0460 7130              *
0461 7130              * 26 Feb 89         Steven Glass
0462 7130              *
0463 7130              * PHD at start.  PLD at end.
0464 7130              *
0465 7130              ***************************************************************
0466 7130              FixHandle2 PROC EXPORT 
0467 7130
0468 7130              SaveHandle equ   $b0
0469 7130
0470 7130 0B                    phd   
0471 7131 7B                    tdc                            ; assume we enter with direct page
0472 7132 18                    clc                            ; set to quickdraw
0473 7133 69 00 01              adc   #$100
0474 7136 5B                    tcd   
0475 7137
0476 7137 48                    pha                            ; space for new handle below
0477 7138 48                    pha   
0478 7139
0479 7139 48                    pha                            ; get the size of the current
0480 713A 48                    pha                            ; handle
0481 713B D4 B2                 pei   SaveHandle+2
0482 713D D4 B0                 pei   SaveHandle
0483 713F A2 02 18 22           _GetHandleSize 
0484 7146
0485 7146
0486 7146 D4 B2                 pei   SaveHandle+2             ; dispose of the current handle
0487 7148 D4 B0                 pei   SaveHandle
0488 714A A2 02 10 22           _DisposeHandle 
0489 7151
0490 7151 7B                    tdc                            ; at this point the space for the
0491 7152 38                    sec                            ; handle and the size of the
0492 7153 E9 00 01              sbc   #$100                    ; handle are on the stack.  Now I
0493 7156 AA                    tax                            ; add the user id and the attributes
0494 7157 BF 0A 00 00           lda   >UserID,x
0495 715B 48                    pha   
0496 715C
0497 715C F4 10 80              PushWord #%1000000000010000    ; locked, no bank cross
0498 715F
0499 715F 48                    pha                            ; finally the location info which is
0500 7160 48                    pha                            ; ignored
0501 7161 A2 02 09 22           _NewHandle 
0502 7168
0503 7168 68                    pla   
0504 7169 85 B0                 sta   SaveHandle
0505 716B 68                    pla   
0506 716C 85 B2                 sta   SaveHandle+2
0507 716E
0508 716E 48                    pha   
0509 716F 48                    pha   
0510 7170 A2 04 8F 22           _GetCursorAdr 
0511 7177 A2 04 8E 22           _SetCursor 
0512 717E
0513 717E 2B                    pld   
0514 717F
0515 717F 6B                    rtl   
0516 7180
0517 7180                       ENDP 
0518 7180
0519 7180              *****************************************************************
0520 7180              *
0521 7180              * ClearScreen patch 25-Nov-90 DAL
0522 7180              *
0523 7180              * If DontClearScrnFlag is set, clear it and don't do
0524 7180              * anything.  Otherwise jump to ROM.
0525 7180              *
0526 7180              *****************************************************************
0527 7180              MyClearScreen proc export 
0528 7180 AA                    tax                            ;added 19-Feb-91 DAL
0529 7181 AF 9B 74 02           lda   >DontClearScrnFlag
0530 7185 F0 0F                 beq   @toROM
0531 7187 A9 00 00              lda   #0
0532 718A 8F 9B 74 02           sta   >DontClearScrnFlag
0533 718E AA                    tax   
0534 718F A0 02 00              ldy   #2
0535 7192 5C 84 01 E1           jml   $e10184                  ;ToStrip
0536 7196
0537 7196 8A           @toROM   txa                            ;added 19-Feb-91 DAL
0538 7197 5C D8 16 FE           jml   $fe16d8
0539 719B
0540 719B                       entry DontClearScrnFlag 
0541 719B 00 00        DontClearScrnFlag DC W:0
0542 719D
0543 719D                       endp 
0544 719D
0545 719D
0546 719D              *****************************************************************
0547 719D              *
0548 719D              * QDShutDown patch 25-Nov-90 DAL
0549 719D              *
0550 719D              * If Master SCB bit $0100 is set, then we leave the screen
0551 719D              * turned on.
0552 719D              *
0553 719D              MyQDShutDown proc export 
0554 719D              *
0555 719D              * Description:      This patch is very much like what ROM 3 already
0556 719D              *                   does, except it doesn't always turn off the
0557 719D              *                   screen.
0558 719D              *
0559 719D              * Inputs:           None
0560 719D              *
0561 719D              * Outputs:          None
0562 719D              *
0563 719D              * 19-Nov-90 DAL:  Sucked this code into TS2 from QD:Init.asm, routine
0564 719D              *                 CoreTerminate.
0565 719D              * 25-Nov-90 DAL:  Sucked this code into TS3 from TS2.
0566 719D              *
0567 719D              *******************************************************************************
0568 719D
0569 719D              DisposeHandleGlue equ   $fe1327         ;for ROM 3
0570 719D              NewVideo equ   $e0c029
0571 719D
0572 719D              LclRTL   equ   $fe0080                  ;for ROM 3
0573 719D
0574 719D              * MyQDShutDown
0575 719D C9 00 00              cmp   #0
0576 71A0 D0 04                 bne   @Continue
0577 71A2 5C DF FB FE           jml   >$fefbdf                 ;oEndCall0 (ROM 3)
0578 71A6
0579 71A6 20 1B 7A     @Continue jsr   LOCALQDStart
0580 71A9
0581 71A9              *** added 7-Apr-91 DAL
0582 71A9 F4 00 00              pea   0
0583 71AC A2 12 06 22           _QDAuxStatus 
0584 71B3 68                    pla   
0585 71B4 F0 07                 beq   @noQDAux
0586 71B6 A2 12 03 22           _QDAuxShutDown 
0587 71BD              @noQDAux  
0588 71BD              *** end of 7-Apr-91 DAL
0589 71BD
0590 71BD              *** added 19-Nov-91 DAL -- fix up the color tables and SCBs
0591 71BD 48                    pha   
0592 71BE A2 04 17 22           _GetMasterSCB 
0593 71C5 68                    pla   
0594 71C6 29 F0 FF              and   #$FFF0
0595 71C9 09 80 00              ora   #$0080
0596 71CC 48                    pha   
0597 71CD A2 04 16 22           _SetMasterSCB 
0598 71D4 F4 E1 00 F4           pushlong #$E19E00 
0599 71DA A2 04 0D 22           _InitColorTable 
0600 71E1 F4 80 00              pea   $0080
0601 71E4 A2 04 14 22           _SetAllSCBs 
0602 71EB              *** end 19-Nov-91
0603 71EB
0604 71EB F4 02 00              pea   #2                       ; set the purge level to 2
0605 71EE A2 00 02              ldx   #512                     ; on the fastfont...
0606 71F1 B5 F2                 lda   FastRomFont+2,x
0607 71F3 29 FF 00              and   #$00FF
0608 71F6 48                    pha   
0609 71F7 B5 F0                 lda   FastRomFont,x
0610 71F9 48                    pha   
0611 71FA A2 02 24 22           _SetPurge 
0612 7201              *
0613 7201              * Deallocate rgn cache memory
0614 7201              *
0615 7201 A2 F4 02              ldx   #$02F4
0616 7204 B5 02                 lda   2,x
0617 7206 48                    pha   
0618 7207 B5 00                 lda   0,x
0619 7209 48                    pha   
0620 720A 22 27 13 FE           jsl   DisposeHandleGlue
0621 720E
0622 720E              ;-----------------------------------------------
0623 720E              ;
0624 720E              ; Close the first port and get rid of the memory
0625 720E              ; it is in.
0626 720E              ;
0627 720E A2 00 01              ldx   #256
0628 7211 B5 0C                 lda   FirstPortHandle+2,x
0629 7213 48                    pha   
0630 7214 85 2C                 sta   temp+2
0631 7216 B5 0A                 lda   FirstPortHandle,x
0632 7218 48                    pha   
0633 7219 85 2A                 sta   temp
0634 721B A7 2A                 lda   [temp]
0635 721D AA                    tax   
0636 721E A0 02 00              ldy   #2
0637 7221 B7 2A                 lda   [temp],y
0638 7223 48                    pha   
0639 7224 DA                    phx   
0640 7225 A2 04 1A 22           _ClosePort 
0641 722C 22 27 13 FE           jsl   DisposeHandleGlue
0642 7230
0643 7230              ;-----------------------------------------------
0644 7230              ;
0645 7230              ; Get rid of text buffer
0646 7230              ;
0647 7230 D4 46                 pei   TextBufHandle+2
0648 7232 D4 44                 pei   TextBufHandle
0649 7234 22 27 13 FE           jsl   DisposeHandleGlue
0650 7238
0651 7238
0652 7238              ;-----------------------------------------------
0653 7238              ;
0654 7238              ; Get rid of the buffer memory
0655 7238
0656 7238 D4 3E                 pei   BufferHandle+2
0657 723A D4 3C                 pei   BufferHandle
0658 723C 22 27 13 FE           jsl   DisposeHandleGlue
0659 7240
0660 7240              ;-----------------------------------------------
0661 7240              ; Get rid of shadowed ram here
0662 7240              ; test for shadowing enabled, if it is, turn it off and 
0663 7240              ; dispose of the screen...
0664 7240 E2 20                 sep   #$20                     ; turn off long <A>
0665 7242                       longA Off
0666 7242 AF 35 C0 E0           lda   >$E0C035                 ; load the shadow register
0667 7246 29 08                 and   #$08                     ; set bit 3... (turn screen shadow off)
0668 7248 D0 18                 bne   @NotShadowed
0669 724A                       longA On
0670 724A C2 20                 REP   #$20                     ; and turn back on long <A>
0671 724C
0672 724C 48                    pha   
0673 724D 48                    pha   
0674 724E F4 01 00              pea   $0001                    ; find the shadowed screen memory
0675 7251 F4 00 20              pea   $2000                    ; handle, shadowing was on...
0676 7254 A2 02 1A 22           _FindHandle 
0677 725B A2 02 10 22           _DisposeHandle                 ; and throw it the hell away..
0678 7262              @NotShadowed  
0679 7262                       longA On
0680 7262 C2 20                 REP   #$20
0681 7264              ;-----------------------------------------------
0682 7264              ;
0683 7264              ; Now get rid of screen memory.  Cannot do a find
0684 7264              ; since we could be called after a startup call
0685 7264              ; that was aborted because screen was already
0686 7264              ; owned.  We don't want to release someone
0687 7264              ; else's memory.
0688 7264              ;
0689 7264 A2 00 01              ldx   #256
0690 7267 B5 08                 lda   ScreenHandle+2,x
0691 7269 48                    pha   
0692 726A B5 06                 lda   ScreenHandle,x
0693 726C 48                    pha   
0694 726D 22 27 13 FE           jsl   DisposeHandleGlue
0695 7271
0696 7271              ;-----------------------------------------------
0697 7271              ;
0698 7271              ; Get rid of the memory used by cursor save
0699 7271              ;
0700 7271 4B 62 06 00           jsrl $fe4fb2                   ;CursorShutDown (ROM 3)
0701 727C
0702 727C
0703 727C              ;----------------------------------------------------
0704 727C              ;
0705 727C              ; Turn off graphics and linearization in bank 1/E1
0706 727C              ;
0707 727C
0708 727C              ;	pha		;added 19-Nov-90 DAL
0709 727C              ;	_GetMasterSCB	;added 19-Nov-90 DAL
0710 727C              ;	pla		;added 19-Nov-90 DAL
0711 727C              ;	and	#$0100	;added 19-Nov-90 DAL
0712 727C              ;	bne	@1	;added 19-Nov-90 DAL
0713 727C              ;
0714 727C              ;	sep	#$30	; go to 8 bit mode
0715 727C              ;	longa	off
0716 727C              ;	longi	off
0717 727C              ;	lda	>NewVideo
0718 727C              ;	and	#%00111111	; turn off graphics and linearization
0719 727C              ;	sta	>NewVideo
0720 727C              ;	rep	#$30	; go back to 16
0721 727C              ;	longi	on
0722 727C              ;	longa	on
0723 727C              ;@1			;added 19-Nov-90 DAL
0724 727C              *** added 6-Sep-91 DAL -- turn off linearization, or SHR+linearization
0725 727C 48                    pha   
0726 727D A2 04 17 22           _GetMasterSCB 
0727 7284 68                    pla   
0728 7285 A2 3F 00              ldx   #%00111111
0729 7288 29 00 01              and   #$0100                   ;bit 8 = leave SHR screen showing!
0730 728B F0 03                 beq   @1                       ;turn off both
0731 728D A2 BF 00              ldx   #%10111111               ;turn off linear, leave screen on
0732 7290 8A           @1       txa   
0733 7291 E2 30                 sep   #$30
0734 7293 2F 29 C0 E0           and   >NewVideo
0735 7297 8F 29 C0 E0           sta   >NewVideo
0736 729B C2 30                 rep   #$30
0737 729D              *** end of 6-Sep-91 DAL
0738 729D
0739 729D
0740 729D              ;-----------------------------------------------
0741 729D              ;
0742 729D              ; Clear the entry in the WAPT
0743 729D              ;
0744 729D A9 00 00              lda   #0                       ; not a user call (seed the a-reg
0745 72A0 48                    pha                            ; to save bytes below
0746 72A1 F4 04 00              PushWord #TSNumber             ; Put TSNum on stack
0747 72A4 48                    pha                            ; new value is zero as set above.
0748 72A5 48                    pha   
0749 72A6 A2 01 0D 22           _SetWAP 
0750 72AD
0751 72AD
0752 72AD              ;------------------------------------------------------
0753 72AD              ; Turn off shadowing for the SHR Screen
0754 72AD              ;
0755 72AD E2 20                 sep   #$20                     ; turn off long <A>
0756 72AF                       longA Off
0757 72AF AF 35 C0 E0           lda   >$E0C035                 ; load the shadow register
0758 72B3 09 08                 ora   #$08                     ; set bit 3... (turn screen shadow off)
0759 72B5 8F 35 C0 E0           sta   >$E0C035                 ; and resave it!
0760 72B9                       longA On
0761 72B9 C2 20                 REP   #$20                     ; and turn back on long <A>
0762 72BB
0763 72BB 5C EA FB FE           jml   >$fefbea                 ;ROM 3
0764 72BF
0765 72BF                       EndP 
0766 72BF
0767 72BF
0768 72BF              ****************************************************************
0769 72BF              *
0770 72BF              iGimmeVersion PROC Export 
0771 72BF              *
0772 72BF              * Vectored routine to return QD's version number
0773 72BF              *
0774 72BF              *
0775 72BF              * Inputs:
0776 72BF              *                   none
0777 72BF              *
0778 72BF              * Outputs:
0779 72BF              *                   a-reg
0780 72BF              *
0781 72BF              * External Refs:
0782 72BF              *                   none
0783 72BF              *
0784 72BF              * Entry Points:
0785 72BF              *                   none
0786 72BF              *
0787 72BF                       longa on                       ; mode
0788 72BF                       longi on 
0789 72BF              *
0790 72BF              ****************************************************************
0791 72BF
0792 72BF
0793 72BF A9 08 03              lda   #$0308                   ;2-Apr-93 DAL
0794 72C2 6B                    rtl   
0795 72C3
0796 72C3                       ENDP 
0797 72C3
0798 72C3                       EJECT 
0799 72C3              *******************************************************************************
0800 72C3              *
0801 72C3              iSetUpScanPtrs PROC Export 
0802 72C3              *
0803 72C3              * Description:      this is to patch a bug in the firmware that does not properly
0804 72C3              *                   call init3Regions via the vector. This is so quickergraph can work
0805 72C3              *                   Currently the only offender is irgnblt
0806 72C3              *
0807 72C3              *
0808 72C3              * Inputs:           This routine should be relatively non destructive, except that 
0809 72C3              *                   <A> and <X> can both be trashed if we want.
0810 72C3              *
0811 72C3              * Outputs:          None
0812 72C3              *
0813 72C3              * External Refs:
0814 72C3              *
0815 72C3              * Entry Points:
0816 72C3              *
0817 72C3              *******************************************************************************
0818 72C3              ROMSetUpScanPtrs equ   $FE5C0A
0819 72C3              ROMRgnBltOffsnder equ   $FE45D3
0820 72C3              ROMGoodRgnBltRtn equ   $45D7
0821 72C3
0822 72C3 22 0A 5C FE           jsl   ROMSetUpScanPtrs
0823 72C7
0824 72C7 A3 01                 lda   1,s                      ; look at the return address
0825 72C9 C9 D3 45              cmp   #<ROMRgnBltOffsnder
0826 72CC F0 01                 beq   @1
0827 72CE 6B           @GoodCall RTL                           ; not rgnblt we can simply return
0828 72CF A3 02        @1       lda   2,s
0829 72D1 C9 45 FE              cmp   #ROMRgnBltOffsnder>>8
0830 72D4 D0 F8                 bne   @goodcall
0831 72D6 22 C4 1E E0           jsl   Init3Regions
0832 72DA A9 D7 45              lda   #ROMGoodRgnBltRtn
0833 72DD 83 01                 sta   1,s
0834 72DF 6B                    RTL   
0835 72E0                       EndP 
0836 72E0
0837 72E0
0838 72E0              ****************************************************************
0839 72E0              *
0840 72E0              iSeekRgn Proc Export 
0841 72E0              *
0842 72E0              * The state record for the region to seek is passed in StatePtr
0843 72E0              *
0844 72E0              * 3/19/90           Patched to set up the rgnptr properly from the
0845 72E0              *                   stateptr data. This Should fix many crash/hang problems
0846 72E0              *                   with copybits and scrollrect
0847 72E0              *
0848 72E0              ROMItsRectangular equ   $FE60EA
0849 72E0              ROMGoingDown equ   $FE6013
0850 72E0              ROMGoingUp equ   $FE6124
0851 72E0              *
0852 72E0              ****************************************************************
0853 72E0 A7 84                 lda   [StatePtr]
0854 72E2 10 04                 bpl   @TestMore
0855 72E4 5C EA 60 FE           jml   ROMItsRectangular
0856 72E8 A0 1E 00     @TestMore ldy   #S_SeekDir
0857 72EB B7 84                 lda   [StatePtr],y
0858 72ED D0 04                 bne   @MustPatch
0859 72EF 5C 13 60 FE           jml   ROMGoingDown
0860 72F3              @MustPatch  
0861 72F3              ; If we get here we are going backwards and need to set up 
0862 72F3 A0 02 00              ldy   #s_RgnPtr                ; get the pointer to the region
0863 72F6 B7 84                 lda   [StatePtr],y             ; add 10 and put result in the
0864 72F8 85 80                 sta   RgnPtr
0865 72FA A0 04 00              ldy   #s_RgnPtr+2
0866 72FD B7 84                 lda   [StatePtr],y
0867 72FF 85 82                 sta   RgnPtr+2
0868 7301 5C 24 61 FE           jml   ROMGoingUp
0869 7305                       EndP 
0870 7305
0871 7305                       EJECT 
0872 7305              *******************************************************************************
0873 7305              *
0874 7305              iSetSliceAdr PROC Export 
0875 7305              *
0876 7305              * Description:      Patch all the backwards slices to properly set the <X>
0877 7305              *                   register for xShiftStay.
0878 7305              *
0879 7305              *
0880 7305              * Inputs:           None
0881 7305              *
0882 7305              * Outputs:          None
0883 7305              *
0884 7305              * External Refs:
0885 7305              *
0886 7305              ROMSetSliceAdr equ   $FE4B0B
0887 7305              ROMBFCopySLice equ   $FE3B5C            ; oops...
0888 7305              ROMBFORSlice equ   $FE3BCF
0889 7305              ROMBFXORSLICE equ   $FE3C3B
0890 7305              ROMBFBICSlice equ   $FE3CA7
0891 7305              XferMode equ   $E4                      ; equate from ROM
0892 7305              HorBackward equ   $CA                   ; equate from ROM
0893 7305              * Entry Points:
0894 7305              *
0895 7305              *******************************************************************************
0896 7305 A5 E4                 lda   XFerMode                 ; take the tranfer mode
0897 7307 29 7F 00              and   #$7F                     ; mask off not bit
0898 730A 0A                    asl   a                        ; double
0899 730B 0A                    asl   a                        ; and double again
0900 730C AA                    tax                            ; put in x
0901 730D
0902 730D
0903 730D A5 42                 lda   HowFarToShift            ; if i don't have to shift at all
0904 730F F0 15                 beq   ToROM                    ; then I can use the fast slice routines
0905 7311
0906 7311 24 CA                 bit   HorBackward              ; oh well so I use the slow ones.
0907 7313 10 11                 bpl   ToROM
0908 7315
0909 7315 BF 2A 76 02           lda   >BackSliceAdrTable,x
0910 7319 8F 00 1E E0           sta   >ToSlice
0911 731D BF 2C 76 02           lda   >BackSliceAdrTable+2,x
0912 7321 8F 02 1E E0  StoreIt  sta   >ToSlice+2
0913 7325
0914 7325 6B                    rtl   
0915 7326 5C 0B 4B FE  ToROM    JML   ROMSetSliceAdr
0916 732A
0917 732A              BackSliceAdrTable  
0918 732A
0919 732A 5C 5C 3B FE           jml   ROMBFCopySlice
0920 732E 5C 3A 76 02           jml   BFORSlice
0921 7332 5C 40 76 02           jml   BFXORSlice
0922 7336 5C 46 76 02           jml   BFBICSlice
0923 733A
0924 733A              BFORSlice  
0925 733A A6 42                 ldx   HowFarToShift
0926 733C 5C CF 3B FE           jml   ROMBFORSlice
0927 7340              BFXORSlice  
0928 7340 A6 42                 ldx   HowFarToShift
0929 7342 5C 3B 3C FE           jml   ROMBFXORSlice
0930 7346              BFBICSlice  
0931 7346 A6 42                 ldx   HowFarToShift
0932 7348 5C A7 3C FE           jml   ROMBFBICSlice
0933 734C                       EndP 
0934 734C
0935 734C
0936 734C              ****************************************************************
0937 734C              *
0938 734C              * SetSlabAdr
0939 734C              *
0940 734C              * This routine sets of the vector "ToSlab" in bank E0.  All
0941 734C              * drawing routines use this vector to get to their slab routine.
0942 734C              *
0943 734C              * If the clipping is non-rectangular or the drawing mask is
0944 734C              * not all $FFFF's, then we use the normal slabs.  Otherwise
0945 734C              * we use the FAST SLABS.
0946 734C              *
0947 734C              * 2/28/89           Konstantin and Dave
0948 734C              * Also, returned in carry whether a fast slab is being used, and
0949 734C              * returned in <X> is the offset to the slab table. THIS SHOULD
0950 734C              * NOT CHANGE
0951 734C              ****************************************************************
0952 734C              iSetSlabAdr PROC EXPORT 
0953 734C
0954 734C A5 B6                 lda   FillMode
0955 734E 29 7F 00              and   #$7F
0956 7351 0A                    asl   a
0957 7352 0A                    asl   a
0958 7353 AA                    tax   
0959 7354
0960 7354 A5 A4                 lda   NonRectRegions
0961 7356 D0 17                 bne   GoSlow
0962 7358
0963 7358 A0 6A 00              ldy   #o_PnMask                ;go fast if there is no mask
0964 735B B7 24                 lda   [PortRef],y
0965 735D A0 6C 00              ldy   #o_PnMask+2
0966 7360 37 24                 and   [PortRef],y
0967 7362 A0 6E 00              ldy   #o_PnMask+4
0968 7365 37 24                 and   [PortRef],y
0969 7367 A0 70 00              ldy   #o_PnMask+6
0970 736A 37 24                 and   [PortRef],y
0971 736C 1A                    inc   a                        ;are they all $FFFF?
0972 736D F0 12                 beq    GoFast
0973 736F              GoSlow                                  ;
0974 736F
0975 736F
0976 736F BF 93 76 02           lda   >SlabTable,x
0977 7373 8F 00 1E E0           sta   >ToSlab
0978 7377 BF 95 76 02           lda   >SlabTable+2,x
0979 737B 8F 02 1E E0           sta   >ToSlab+2
0980 737F 38                    sec                            ;we must go slow
0981 7380 6B                    rtl   
0982 7381
0983 7381              GoFast    
0984 7381 BF A3 76 02           lda   >FastSlabTable,x
0985 7385 8F 00 1E E0           sta   >ToSlab
0986 7389 BF A5 76 02           lda   >FastSlabTable+2,x
0987 738D 8F 02 1E E0           sta   >ToSlab+2
0988 7391 18                    clc                            ;signals that we can go fast
0989 7392 6B                    rtl   
0990 7393
0991 7393                       ENDP 
0992 7393
0993 7393
0994 7393
0995 7393              ****************************************************************
0996 7393              *
0997 7393              * SlabTable
0998 7393              *
0999 7393              ****************************************************************
1000 7393              SlabTable PROC EXPORT 
1001 7393
1002 7393 5C F9 76 02           jml   OurSlabCopy
1003 7397 5C 1C 77 02           jml   OurSlabOR
1004 739B 5C 31 77 02           jml   OurSlabXOR
1005 739F 5C 46 77 02           jml   OurSlabBIC
1006 73A3
1007 73A3                       ENDP 
1008 73A3
1009 73A3
1010 73A3              ****************************************************************
1011 73A3              *
1012 73A3              * FastSlabTable
1013 73A3              *
1014 73A3              ****************************************************************
1015 73A3              FastSlabTable PROC EXPORT 
1016 73A3
1017 73A3 5C D6 76 02           jml   PatchSlabCopy
1018 73A7 5C 90 2C FE           jml   FastSlabOR
1019 73AB 5C B3 76 02           jml   PatchSlabXOR
1020 73AF 5C 09 2D FE           jml   FastSlabBIC
1021 73B3
1022 73B3                       ENDP 
1023 73B3
1024 73B3
1025 73B3              ****************************************************************
1026 73B3              *
1027 73B3              PatchSlabXOR PROC EXPORT 
1028 73B3              *
1029 73B3              *
1030 73B3              * 6/15/89           Mensch
1031 73B3              *
1032 73B3              * Drastically modified for slab entry for the patch
1033 73B3              *
1034 73B3              ****************************************************************
1035 73B3              ;---------------------------------------------------------------
1036 73B3              MaxWordsInRow equ   80
1037 73B3              MaxBytesInRow equ   MaxWordsInRow*2
1038 73B3              ;---------------------------------------------------------------
1039 73B3
1040 73B3              ;---------------------------------------------------------------
1041 73B3 A5 CA                 lda   Pat                      ;if the patterns are equal go very fast
1042 73B5 C5 CC                 cmp   Pat+2
1043 73B7 F0 04                 beq   tryReallyFast
1044 73B9 5C 21 27 FE  exit1    jml   FastSlabXOR              ; if the pats are not equal use ROMslabs
1045 73BD              tryReallyFast  
1046 73BD A5 C6                 lda   FinishWord               ;get the number of bytes to XOR into the
1047 73BF 38                    sec                            ;..A-Reg
1048 73C0 E5 C4                 sbc   StartWord
1049 73C2 F0 F5                 beq   exit1                    ;if only one word, do a special case
1050 73C4 4A                    lsr   a
1051 73C5 3A                    dec   a                        ;if only two words, then do another
1052 73C6 F0 F1                 beq   exit1                    ;..special case
1053 73C8 AA                    tax                            ;otherwise the count goes in X-Reg
1054 73C9 C9 50 00              cmp   #MaxWordsInRow           ; do we hit the threshhold?
1055 73CC B0 04                 bge   exit2                    ; if less than max in rom do exit1
1056 73CE 5C 96 27 FE           jml   GoReallyFastXOR
1057 73D2 5C 42 27 FE  Exit2    jml   FastSlabXORAlt           ; else do the fast slab xor alt
1058 73D6                       EndP 
1059 73D6
1060 73D6              ****************************************************************
1061 73D6              *
1062 73D6              PatchSlabCopy PROC EXPORT 
1063 73D6              *
1064 73D6              * 6/15/89           Mensch
1065 73D6              *
1066 73D6              * Made entry to fastslabcopy modified version for the patch
1067 73D6              ****************************************************************
1068 73D6              ;---------------------------------------------------------------
1069 73D6              MaxWordsInRow equ    80
1070 73D6
1071 73D6              ;---------------------------------------------------------------
1072 73D6 A5 CA                 lda   Pat                      ;if the patterns are equal go very fast
1073 73D8 C5 CC                 cmp   Pat+2
1074 73DA F0 04                 beq   tryReallyFast
1075 73DC 5C 26 2A FE  exit1    jml   FastSlabCopy             ; if the pats are not equal use ROMslabs
1076 73E0              tryReallyFast  
1077 73E0 A5 C6                 lda   FinishWord               ;get the number of bytes to XOR into the
1078 73E2 38                    sec                            ;..A-Reg
1079 73E3 E5 C4                 sbc   StartWord
1080 73E5 F0 F5                 beq   exit1                    ;if only one word, do a special case
1081 73E7 4A                    lsr   a
1082 73E8 3A                    dec   a                        ;if only two words, then do another
1083 73E9 F0 F1                 beq   exit1                    ;..special case
1084 73EB AA                    tax                            ;otherwise the count goes in X-Reg
1085 73EC C9 50 00              cmp   #MaxWordsInRow           ; do we hit the threshhold?
1086 73EF B0 04                 bge   exit2                    ; if less than max in rom do exit1
1087 73F1 5C 9F 2A FE           jml   GoReallyFastCopy
1088 73F5 5C 47 2A FE  Exit2    jml   FastSlabCopyAlt          ; else do the fast slab xor alt
1089 73F9                       EndP 
1090 73F9
1091 73F9
1092 73F9              ****************************************************************
1093 73F9              *
1094 73F9              OurSlabs PROC 
1095 73F9              *
1096 73F9              * These are the patched slabs.  The each swap the pen mask, call
1097 73F9              * the old mask and swap it back.
1098 73F9              *
1099 73F9              *
1100 73F9              * Inputs:
1101 73F9              *                   none
1102 73F9              *
1103 73F9              * Outputs:
1104 73F9              *                   none
1105 73F9              *
1106 73F9              * External Refs:
1107 73F9              *                   none
1108 73F9              *
1109 73F9              * Entry Points:
1110 73F9              *                   none
1111 73F9              *
1112 73F9                       longa on                       ; mode
1113 73F9                       longi on 
1114 73F9              *
1115 73F9              ****************************************************************
1116 73F9
1117 73F9
1118 73F9                       ENTRY OurSlabCopy 
1119 73F9              OurSlabCopy  
1120 73F9 A5 C4 29 02           SwapMask 
1121 7408 22 D0 24 FE           jsl   SlabCopy
1122 740C A5 C4 29 02  GetOut   SwapMask 
1123 741B 6B                    rtl   
1124 741C
1125 741C                       ENTRY OurSlabOR 
1126 741C              OurSlabOR  
1127 741C A5 C4 29 02           SwapMask 
1128 742B 22 68 25 FE           jsl   SlabOR
1129 742F 80 DB                 bra   GetOut
1130 7431
1131 7431                       ENTRY OurSlabXOR 
1132 7431              OurSlabXOR  
1133 7431 A5 C4 29 02           SwapMask 
1134 7440 22 F6 25 FE           jsl   SlabXOR
1135 7444 80 C6                 bra   GetOut
1136 7446
1137 7446                       ENTRY OurSlabBIC 
1138 7446              OurSlabBIC  
1139 7446 A5 C4 29 02           SwapMask 
1140 7455 22 84 26 FE           jsl   SlabBIC
1141 7459 80 B1                 bra   GetOut
1142 745B
1143 745B                       ENDP 
1144 745B
1145 745B
1146 745B
1147 745B              ****************************************************************
1148 745B              *
1149 745B              iRotateMask PROC Export 
1150 745B              *
1151 745B              * The code in rom does the wrong thing if the arcrot field
1152 745B              * has the high bit set.  So we skipp the bad code.
1153 745B              *
1154 745B              *
1155 745B              *
1156 745B              * Inputs:
1157 745B              *                   a-reg has something important in it
1158 745B              *
1159 745B              * Outputs:
1160 745B              *                   and its on the stack by the time
1161 745B              *                   we get to the new code.
1162 745B              *
1163 745B              * External Refs:
1164 745B              *                   none
1165 745B              *
1166 745B              * Entry Points:
1167 745B              *                   none
1168 745B              *
1169 745B                       longa on                       ; mode
1170 745B                       longi on 
1171 745B              *
1172 745B              ****************************************************************
1173 745B
1174 745B
1175 745B              BackIntoROM equ   $FE20AD
1176 745B
1177 745B
1178 745B 48                    pha   
1179 745C 5C AD 20 FE           jml   BackIntoROM
1180 7460
1181 7460                       ENDP 
1182 7460
1183 7460
1184 7460
1185 7460                       if 1 then 
1186 7460
1187 7460                       EJECT 
1188 7460              *******************************************************************************
1189 7460              *
1190 7460              MySetCursor PROC Export 
1191 7460              *
1192 7460              * Description:      This routine does exactly what the very start of
1193 7460              *                   the real set cursor does except that it also tests the MasterSCB
1194 7460              *                   to see if the SetCursNoDraw bit is set...
1195 7460              *
1196 7460              *
1197 7460              * Inputs:           None
1198 7460              *
1199 7460              * Outputs:          None
1200 7460              *
1201 7460              * External Refs:
1202 7460              ROMNotVisible equ   $FE50A4
1203 7460              ;CursorLevel	equ	$CC
1204 7460              ;ObscureFlag	equ	$CE
1205 7460              ;CursorMode	equ	$6A
1206 7460              *
1207 7460              *******************************************************************************
1208 7460              OrigP    equ   1
1209 7460              OrigDirect equ   OrigP+1
1210 7460              RTL1     equ   OrigDirect+2
1211 7460              RTL2     equ   RTL1+3
1212 7460              TheCursorPtr equ   RTL2+3
1213 7460
1214 7460              StartofZP equ   CursorSTART
1215 7460
1216 7460              UseInterrupts equ   StartofZP
1217 7460              IntPending equ   UseInterrupts+2
1218 7460
1219 7460              MouseY   equ   IntPending+2
1220 7460              MouseX   equ   MouseY+2
1221 7460
1222 7460              NextMouseY equ   MouseX+2
1223 7460              NextMouseX equ   NextMouseY+2
1224 7460
1225 7460              CurHeight equ   NextMouseX+2            ; Num scan lines high of cursor
1226 7460              CurWidth equ   CurHeight+2              ; Num WORDS wide of cursor
1227 7460
1228 7460              CursorRect equ   CurWidth+2
1229 7460              CursorY1 equ   CursorRect
1230 7460              CursorX1 equ   CursorY1+2
1231 7460              CursorY2 equ   CursorX1+2
1232 7460              CursorX2 equ   CursorY2+2
1233 7460
1234 7460              CursorMode equ   CursorX2+2
1235 7460              CursorRecPtr equ   CursorMode+2
1236 7460
1237 7460              CursorPtr equ   CursorRecPtr+4
1238 7460              MaskPtr  equ   CursorPtr+4
1239 7460
1240 7460              CursorPtr1 equ   MaskPtr+4
1241 7460              MaskPtr1 equ   CursorPtr1+4
1242 7460              CursorPtr2 equ   MaskPtr1+4
1243 7460              MaskPtr2 equ   CursorPtr2+4
1244 7460              CursorPtr3 equ   MaskPtr2+4
1245 7460              MaskPtr3 equ   CursorPtr3+4
1246 7460              CursorPtr4 equ   MaskPtr3+4
1247 7460              MaskPtr4 equ   CursorPtr4+4
1248 7460              CursorPtr5 equ   MaskPtr4+4
1249 7460              MaskPtr5 equ   CursorPtr5+4
1250 7460              CursorPtr6 equ   MaskPtr5+4
1251 7460              MaskPtr6 equ   CursorPtr6+4
1252 7460              CursorPtr7 equ   MaskPtr6+4
1253 7460              MaskPtr7 equ   CursorPtr7+4
1254 7460
1255 7460              SaveHandle equ   MaskPtr7+4
1256 7460
1257 7460              SavePtr  equ   SaveHandle+4
1258 7460              SaveSize equ   SavePtr+4
1259 7460
1260 7460              CursorRef equ   SaveSize+2
1261 7460              MaskRef  equ   CursorRef+4
1262 7460              HotSpot  equ   MaskRef+4
1263 7460
1264 7460              SaveRef  equ   HotSpot+4
1265 7460              ScreenRef equ   SaveRef+4
1266 7460
1267 7460              CursorLevel equ   ScreenRef+2
1268 7460              ObscureFlag equ   CursorLevel+2
1269 7460
1270 7460
1271 7460 A8                    tay   
1272 7461 A3 09                 lda   9,s                      ;high word of cursor ptr
1273 7463 AA                    tax   
1274 7464 0A                    asl   a
1275 7465 4A                    lsr   a
1276 7466 83 09                 sta   9,s                      ;cleared bit 31
1277 7468 98                    tya                            ;A=preserved, X=high word of input
1278 7469
1279 7469 20 1B 7A              jsr   LOCALQDStart
1280 746C 18                    clc   
1281 746D 69 00 01              adc   #$100
1282 7470 5B                    tcd   
1283 7471
1284 7471 08                    php                            ; save processor
1285 7472 78                    sei                            ; turn off interrupts to do this
1286 7473
1287 7473 24 CC                 bit   <CursorLevel
1288 7475 30 0C                 bmi   NotVisible
1289 7477
1290 7477 24 CE                 bit   <ObscureFlag
1291 7479 30 08                 bmi   NotVisible
1292 747B
1293 747B 8A                    txa   
1294 747C 30 09                 bmi   NoFlicker
1295 747E 7B                    tdc   
1296 747F 22 D0 1F E0           jsl   UnDrawCursor             ; restore under cursor
1297 7483
1298 7483 5C A4 50 FE  NotVisible jml   ROMNotVisible
1299 7487
1300 7487              NoFlicker  
1301 7487 A3 0A                 lda   10,s                     ;get pointer to cursor rec
1302 7489 85 6C                 sta   CursorRecPtr
1303 748B A3 0C                 lda   10+2,s                   ;high word of new cursor rec
1304 748D 85 6E                 sta   CursorRecPtr+2
1305 748F
1306 748F              ;	lda	[CursorRecPtr]	; I move height and width
1307 748F              ;	sta	CurHeight	; to zero page
1308 748F              ;	ldy	#2
1309 748F              ;	lda	[CursorRecPtr],y
1310 748F              ;	sta	CurWidth
1311 748F
1312 748F A5 6C                 lda   CursorRecPtr             ; point to cursor image
1313 7491 18                    clc   
1314 7492 69 04 00              adc   #4
1315 7495 85 70                 sta   CursorPtr
1316 7497 A5 6E                 lda   CursorRecPtr+2
1317 7499 85 72                 sta   CursorPtr+2
1318 749B
1319 749B A5 B8                 lda   SaveSize                 ; get savesize in a
1320 749D 38                    sec                            ; get rid of extra word per line
1321 749E E5 5E                 sbc   CurHeight
1322 74A0 38                    sec   
1323 74A1 E5 5E                 sbc   CurHeight
1324 74A3 A8                    tay                            ; put copy in Y too
1325 74A4 18                    clc   
1326 74A5 65 70                 adc   CursorPtr
1327 74A7 85 74                 sta   MaskPtr
1328 74A9 A5 72                 lda   CursorPtr+2
1329 74AB 85 76                 sta   MaskPtr+2
1330 74AD
1331 74AD B7 74                 lda   [MaskPtr],y              ; get hot spot
1332 74AF 85 C2                 sta   HotSpot
1333 74B1 C8                    iny   
1334 74B2 C8                    iny   
1335 74B3 B7 74                 lda   [MaskPtr],y
1336 74B5 85 C4                 sta   HotSpot+2
1337 74B7
1338 74B7              ;----------------------------------------------
1339 74B7              ;
1340 74B7              ; Update the appropriate pointers.
1341 74B7              ;
1342 74B7 A5 B4                 lda   SavePtr                  ; the first pointer is savesize past
1343 74B9 18                    clc                            ; saveptr.
1344 74BA 65 B8                 adc   SaveSize
1345 74BC 85 78                 sta   CursorPtr1
1346 74BE A5 B6                 lda   SavePtr+2
1347 74C0 69 00 00              adc   #0
1348 74C3 85 7A                 sta   CursorPtr1+2
1349 74C5
1350 74C5 A2 00 00              ldx   #0
1351 74C8 B5 78        SetUpLoop lda   CursorPtr1,x
1352 74CA 18                    clc   
1353 74CB 65 B8                 adc   SaveSize
1354 74CD 95 7C                 sta   CursorPtr1+4,x
1355 74CF B5 7A                 lda   CursorPtr1+2,x
1356 74D1 69 00 00              adc   #0
1357 74D4 95 7E                 sta   CursorPtr1+6,x
1358 74D6 E8                    inx   
1359 74D7 E8                    inx   
1360 74D8 E8                    inx   
1361 74D9 E8                    inx   
1362 74DA E0 34 00              cpx   #13*4                    ; 52, 7 sets of two pointers
1363 74DD 90 E9                 bcc   SetUpLoop
1364 74DF
1365 74DF              ;----------------------------------------------
1366 74DF              ;
1367 74DF              ; Now I must shift the cursor and mask into
1368 74DF              ; the appropriate places.
1369 74DF              ;
1370 74DF              ***	jsr	ShiftStuff	;$FE4FE6 in ROM 3
1371 74DF 4B                    phk   
1372 74E0 62 06 00              per   @cont-1
1373 74E3 F4 7F 00              pea   $0080-1                  ;$FE0080 is an RTL in ROM 3
1374 74E6 5C E6 4F FE           jml   >$fe4fe6
1375 74EA              @cont     
1376 74EA
1377 74EA
1378 74EA              ;----------------------------------------------
1379 74EA              ;
1380 74EA              ; Now I can show the new cursor
1381 74EA              ;
1382 74EA 24 CC                 bit   CursorLevel
1383 74EC 30 19                 bmi   DoNotShow
1384 74EE 24 CE                 bit   ObscureFlag              ; or should a set cursor unobscure it?
1385 74F0 30 15                 bmi   DoNotShow
1386 74F2
1387 74F2              *** This is really ugly and cruel.  Since there's already an old cursor on
1388 74F2              *** the screen, which I -don't- want to get stuffed into the SaveArea, I
1389 74F2              *** point SavePtr at the ROM around the call to DrawCursor.
1390 74F2 D4 B6                 pei   <SavePtr+2
1391 74F4 D4 B4                 pei   <SavePtr
1392 74F6 A9 FE FE              lda   #$fefe
1393 74F9 85 B6                 sta   <SavePtr+2
1394 74FB 85 B4                 sta   <SavePtr
1395 74FD 22 CC 1F E0           jsl   DrawCursor
1396 7501 68                    pla   
1397 7502 85 B4                 sta   <SavePtr
1398 7504 68                    pla   
1399 7505 85 B6                 sta   <SavePtr+2
1400 7507
1401 7507 28           DoNotShow plp                           ; restore interrupt status
1402 7508 4C FD 7F              jmp   BusyEC4
1403 750B
1404 750B                       EndP 
1405 750B
1406 750B                       EndIf 
1407 750B
1408 750B              ****************************************************************
1409 750B              *
1410 750B              SetPort  PROC Export 
1411 750B              *
1412 750B              * If set port is called from a special place in ROM, there
1413 750B              * is a region we must dispose of.  This region is the temporary
1414 750B              * region allocated to do scrolling in the window manager and
1415 750B              * it is accidentily orphaned.  This patch kills it.
1416 750B              *
1417 750B              *
1418 750B              * Inputs:
1419 750B              *                   none
1420 750B              *
1421 750B              * Outputs:
1422 750B              *                   none
1423 750B              *
1424 750B              * External Refs:
1425 750B              *                   none
1426 750B              *
1427 750B              * Entry Points:
1428 750B              *
1429 750B                       Export FinishSetPort 
1430 750B              *
1431 750B                       longa on                       ; mode
1432 750B                       longi on 
1433 750B              *
1434 750B              ****************************************************************
1435 750B
1436 750B                       DefineStack 
1437 750B              RTL1     block 3 
1438 750B              TheRTL   block 3 
1439 750B              ThePortPtr LONG 
1440 750B
1441 750B
1442 750B              SpecialAddress equ   $FD4b20
1443 750B              *** SpecialAddress2	equ	$FCB839
1444 750B              TempRgn  equ   $19
1445 750B
1446 750B
1447 750B AA                    tax                            ; save the WAP in x
1448 750C
1449 750C              ;
1450 750C              ; Look at the RTL.  If its not the special address, ignore it.
1451 750C              ;
1452 750C A3 04                 lda   TheRTL,s
1453 750E C9 1F 4B              cmp   #<SpecialAddress-1
1454 7511 D0 1A                 bne   NothingSpecial
1455 7513 A3 05                 lda   TheRTL+1,s
1456 7515 C9 4B FD              cmp   #>SpecialAddress-1
1457 7518 D0 13                 bne   NothingSpecial
1458 751A
1459 751A              ;
1460 751A              ; this is it, dispose of the region.
1461 751A              ;
1462 751A
1463 751A DA                    phx                            ; save the wap on the stack
1464 751B
1465 751B D4 1B                 pei   TempRgn+2
1466 751D D4 19                 pei   TempRgn
1467 751F A2 04 68 22           _DisposeRgn 
1468 7526
1469 7526              ;
1470 7526              ; Zero the region so it cannot be disposed again if this code 
1471 7526              ; runs again.
1472 7526              ;
1473 7526 64 1B                 stz   TempRgn+2
1474 7528 64 19                 stz   TempRgn
1475 752A
1476 752A
1477 752A FA                    plx                            ; get WAP back off the stack
1478 752B 80 00                 bra   FinishSetPort
1479 752D
1480 752D
1481 752D              NothingSpecial  
1482 752D              ; (killed, DAL)	lda	TheRTL,s
1483 752D              ;	cmp	#<SpecialAddress2-1
1484 752D              ;	bne	FinishSetPort
1485 752D              ;	lda	TheRTL+1,s
1486 752D              ;	cmp	#>SpecialAddress2-1
1487 752D              ;	bne	FinishSetPort
1488 752D              ;	brl	DoADirtyDeed	; if this matches then do the font manager patch
1489 752D              FinishSetPort  
1490 752D 8A                    txa   
1491 752E
1492 752E              ;
1493 752E              ; Jump back into ROM
1494 752E              ;
1495 752E 5C 32 18 FE           jml   $FE1832
1496 7532
1497 7532                       ENDP 
1498 7532
1499 7532
1500 7532
1501 7532              ****************************************************************
1502 7532              *
1503 7532              SetForeColor PROC Export 
1504 7532              *
1505 7532              * If SetForeColor is being called from the Menu Manager at a
1506 7532              * specific location then we patch the return address back to
1507 7532              * the menu manager with our own address that patches out the
1508 7532              * routine text_guts. This is one of the routines that needed
1509 7532              * to be changed to support icons in menu items. Since this 
1510 7532              * routine is buried deep in the menu manager code it is easier
1511 7532              * to patch it this way.
1512 7532              *
1513 7532              *
1514 7532              * Inputs:
1515 7532              *                   none
1516 7532              *
1517 7532              * Outputs:
1518 7532              *                   none
1519 7532              *
1520 7532              * External Refs:
1521 7532              *                   none
1522 7532              *
1523 7532              * Entry Points:
1524 7532              *
1525 7532                       Export FinishSetForeColor 
1526 7532              *
1527 7532                       longa on                       ; mode
1528 7532                       longi on 
1529 7532              *
1530 7532              ****************************************************************
1531 7532
1532 7532                       DefineStack 
1533 7532              RTL1     block 3 
1534 7532              TheRTL   block 3 
1535 7532              TheColor WORD 
1536 7532
1537 7532              MyAddress1 equ   $FD730C                ; This is the return address to the next instruction after 
1538 7532                                                      ; the SetForeColor call in the MenuMgr code.
1539 7532
1540 7532 AA                    tax                            ; Save the WAP
1541 7533 A3 04                 lda   TheRTL,s
1542 7535 C9 0B 73              cmp   #<MyAddress1-1
1543 7538 D0 0A                 bne   FinishSetForeColor
1544 753A A3 05                 lda   TheRTL+1,s
1545 753C C9 73 FD              cmp   #>MyAddress1
1546 753F D0 03                 bne   FinishSetForeColor
1547 7541 82 A5 DE              brl   DoADirtyDeed2            ; This routine will now patch out the return address
1548 7544                                                      ; back to the menu manager and will now return to the menu patch.
1549 7544
1550 7544 8A           FinishSetForeColor txa                  ; Put WAP back in a-reg.
1551 7545
1552 7545 5C B8 1C FE           jml   $FE1CB8                  ; Jump back to start of SetForeColor call.
1553 7549
1554 7549                       ENDP 
1555 7549
1556 7549              ****************************************************************
1557 7549              *
1558 7549              PtInRect PROC Export 
1559 7549              *
1560 7549              * If SetForeColor is being called from the Menu Manager at a
1561 7549              * specific location then we patch the return address back to
1562 7549              * the menu manager with our own address that patches out the
1563 7549              * routine text_guts. This is one of the routines that needed
1564 7549              * to be changed to support icons in menu items. Since this 
1565 7549              * routine is buried deep in the menu manager code it is easier
1566 7549              * to patch it this way.
1567 7549              *
1568 7549              *
1569 7549              * Inputs:
1570 7549              *                   none
1571 7549              *
1572 7549              * Outputs:
1573 7549              *                   none
1574 7549              *
1575 7549              * External Refs:
1576 7549              *                   none
1577 7549              *
1578 7549              * Entry Points:
1579 7549              *
1580 7549                       Export FinishPtInRect 
1581 7549              *
1582 7549                       longa on                       ; mode
1583 7549                       longi on 
1584 7549              *
1585 7549              ****************************************************************
1586 7549
1587 7549                       DefineStack 
1588 7549              RTL1     block 3 
1589 7549              TheRTL   block 3 
1590 7549              RectPtr  long 
1591 7549              pointPtr long 
1592 7549              result   word 
1593 7549              TheRTS   word 
1594 7549
1595 7549              MyAddress2 equ   $FD6CD1                ; address of instruction after PtInRect call that we want to check
1596 7549              MyAddress3 equ   $FD709C                ; address of instruction after jsr to the routine
1597 7549                                                      ; that calls PtInRect
1598 7549
1599 7549 AA                    tax                            ; Save the WAP
1600 754A A3 04                 lda   TheRTL,s
1601 754C C9 D0 6C              cmp   #<MyAddress2-1
1602 754F D0 11                 bne   FinishPtInRect
1603 7551 A3 05                 lda   TheRTL+1,s
1604 7553 C9 6C FD              cmp   #>MyAddress2
1605 7556 D0 0A                 bne   FinishPtInRect
1606 7558 A3 11                 lda   TheRTS,s
1607 755A C9 9B 70              cmp   #<MyAddress3-1
1608 755D D0 03                 bne   FinishPtInRect
1609 755F 82 11 DF              brl   DoADirtyDeed3            ; This routine will now patch out the return address
1610 7562                                                      ; back to the menu manager.
1611 7562
1612 7562 8A           FinishPtInRect txa                      ; Put WAP back in a-reg.
1613 7563 5C 0C 22 FE           jml   $FE220C                  ; Jump back to start of PtInRect call.
1614 7567
1615 7567
1616 7567                       ENDP 
1617 7567
1618 7567              ****************************************************************
1619 7567              *
1620 7567              * Procedure SectRgn(
1621 7567              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
1622 7567              *   )
1623 7567              *
1624 7567              *   Calculate the intersection of two regions.
1625 7567              *
1626 7567              ****************************************************************
1627 7567              SectRgn  PROC Export 
1628 7567
1629 7567 20 1B 7A              jsr   LOCALQDStart
1630 756A
1631 756A A9 00 00              lda   #0                       ; op := Sect
1632 756D 4C 8B 78              jmp   DoRgnOp                  ; it does all the work
1633 7570
1634 7570                       ENDP 
1635 7570
1636 7570              ****************************************************************
1637 7570              *
1638 7570              * Procedure UnionRgn(
1639 7570              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
1640 7570              *   )
1641 7570              *
1642 7570              *   Calculate the union of two regions.
1643 7570              *
1644 7570              ****************************************************************
1645 7570              UnionRgn PROC Export 
1646 7570
1647 7570 20 1B 7A              jsr   LOCALQDStart
1648 7573
1649 7573 A9 04 00              lda   #4                       ; op := Union
1650 7576 4C 8B 78              jmp   DoRgnOp                  ; it does all the work
1651 7579
1652 7579                       ENDP 
1653 7579
1654 7579              ****************************************************************
1655 7579              *
1656 7579              * Procedure DiffRgn(
1657 7579              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
1658 7579              *   )
1659 7579              *
1660 7579              *   Calculate the difference A-B of two regions.
1661 7579              *
1662 7579              ****************************************************************
1663 7579              DiffRgn  PROC Export 
1664 7579
1665 7579 20 1B 7A              jsr   LOCALQDStart
1666 757C
1667 757C A9 02 00              lda   #2                       ; op := Diff
1668 757F 4C 8B 78              jmp   DoRgnOp                  ; it does all the work
1669 7582
1670 7582                       ENDP 
1671 7582
1672 7582              ****************************************************************
1673 7582              *
1674 7582              * Procedure XorRgn(
1675 7582              *   srcRgnA,srcRgnB,dstRgn:RgnHandle
1676 7582              *   )
1677 7582              *
1678 7582              *   Calculate the exclusive or of two regions.
1679 7582              *
1680 7582              ****************************************************************
1681 7582              XorRgn   PROC Export 
1682 7582
1683 7582 20 1B 7A              jsr   LOCALQDStart
1684 7585
1685 7585 A9 06 00              lda   #6                       ; op := Xor
1686 7588 4C 8B 78              jmp   DoRgnOp                  ; it does all the work
1687 758B
1688 758B                       ENDP 
1689 758B
1690 758B              ****************************************************************
1691 758B              *
1692 758B              * Procedure DoRgnOp;
1693 758B              *
1694 758B              *   Computes the Intersection, Difference, Union, or Xor
1695 758B              *   of two regions.  Enter with Op in A.
1696 758B              *
1697 758B              *    Sect = 0       A-B Diff = 2      Union = 4      Xor = 6
1698 758B              *
1699 758B              ****************************************************************
1700 758B                       EXPORT DoRgnOp 
1701 758B              DoRgnOp  PROC 
1702 758B              *              using E0Vectors
1703 758B
1704 758B              OrigDirect equ   1
1705 758B              RTL1     equ   OrigDirect+2
1706 758B              RTL2     equ   RTL1+3
1707 758B              DstRgn   equ   RTL2+3
1708 758B              SrcRgnB  equ   DstRgn+4
1709 758B              SrcRgnA  equ   SrcRgnB+4
1710 758B
1711 758B 85 BA                 sta   Op                       ; save the operation
1712 758D
1713 758D A3 11                 lda   SrcRgnA,s                ; get low word of SrcRgnA
1714 758F 85 50                 sta   RgnHandleA               ; save it
1715 7591 A3 13                 lda   SrcRgnA+2,s              ; get high word of SrcRgnA
1716 7593 85 52                 sta   RgnHandleA+2             ; save it
1717 7595
1718 7595 A3 0D                 lda   SrcRgnB,s                ; get low word of SrcRgnB
1719 7597 85 60                 sta   RgnHandleB               ; save it
1720 7599 A3 0F                 lda   SrcRgnB+2,s              ; get high word of SrcRgnB
1721 759B 85 62                 sta   RgnHandleB+2             ; save it
1722 759D 20 F3 79              jsr   DerefAB
1723 75A0
1724 75A0 A7 54                 lda   [RgnPtrA]                ; get size of one
1725 75A2 C7 64                 cmp   [RgnPtrB]                ; compare to size of other
1726 75A4 D0 41                 bne   NotSame                  ; if not the same drop to the new rgnop...
1727 75A6
1728 75A6 A8                    tay   
1729 75A7 88                    dey   
1730 75A8 88                    dey   
1731 75A9 B7 54        Loop     lda   [RgnPtrA],y
1732 75AB D7 64                 cmp   [RgnPtrB],y
1733 75AD D0 38                 bne   NotSame
1734 75AF 88                    dey   
1735 75B0 88                    dey   
1736 75B1 D0 F6                 bne   Loop
1737 75B3
1738 75B3              ; was this...
1739 75B3              ;	pha		; room for result
1740 75B3              ;	lda	SrcRgnA+4,s	; get high word
1741 75B3              ;	pha		; push it
1742 75B3              ;	lda	SrcRgnA+4,s	; get low word
1743 75B3              ;	pha		; push it
1744 75B3              ;	lda	SrcRgnA+4,s	; get high word
1745 75B3              ;	pha		; push it
1746 75B3              ;	lda	SrcRgnA+4,s	; get low word
1747 75B3              ;	pha		; push it
1748 75B3              ;	_EqualRgn	; are they equal?
1749 75B3              ;	pla		; get boolean result
1750 75B3              ;	beq	NotSame	; if 0 (false), we have more work
1751 75B3              ; NOTE: If we get here then the regions are the same...
1752 75B3
1753 75B3 A5 BA                 lda   Op                       ; get op
1754 75B5 29 02 00              and   #2                       ; and it with 2 (Diff and Xor bit)
1755 75B8 D0 18                 bne   Zero                     ; zero it if Sect or Union
1756 75BA
1757 75BA              Copy      
1758 75BA              ; This routine copies rgn <A> to dest region...
1759 75BA A3 13                 lda   SrcRgnA+2,s              ; get high word
1760 75BC 48                    pha                            ; push it
1761 75BD A3 13                 lda   SrcRgnA+2,s              ; get low word
1762 75BF 48                    pha                            ; push it
1763 75C0 A3 0F                 lda   DstRgn+6,s               ; get high word
1764 75C2 48                    pha                            ; push it
1765 75C3 A3 0F                 lda   DstRgn+6,s               ; get low word
1766 75C5 48                    pha                            ; push it
1767 75C6 A2 04 69 22           _CopyRgn                       ; copy it
1768 75CD B0 15                 bcs   T1
1769 75CF
1770 75CF 82 A9 00              brl   DoUnlockABNoErr
1771 75D2
1772 75D2 A3 0B        Zero     lda   DstRgn+2,s               ; get high word
1773 75D4 48                    pha                            ; push it
1774 75D5 A3 0B                 lda   DstRgn+2,s               ; get low word
1775 75D7 48                    pha                            ; push it
1776 75D8 A2 04 6A 22           _SetEmptyRgn                   ; zero the destination
1777 75DF B0 03                 bcs   T1
1778 75E1 82 97 00              brl   DoUnlockABNoErr
1779 75E4
1780 75E4 82 9D 00     T1       brl   DoUnlockABError
1781 75E7
1782 75E7              * load the handles from the stack onto zero page and dereference them
1783 75E7
1784 75E7              NotSame   
1785 75E7              ; was this...
1786 75E7              ;	lda	SrcRgnA,s	; get low word of SrcRgnA
1787 75E7              ;	sta	RgnHandleA	; save it
1788 75E7              ;	lda	SrcRgnA+2,s	; get high word of SrcRgnA
1789 75E7              ;	sta	RgnHandleA+2	; save it
1790 75E7              ;	jsr	DerefA
1791 75E7              ;
1792 75E7              ;	lda	SrcRgnB,s	; get low word of SrcRgnB
1793 75E7              ;	sta	RgnHandleB	; save it
1794 75E7              ;	lda	SrcRgnB+2,s	; get high word of SrcRgnB
1795 75E7              ;	sta	RgnHandleB+2	; save it
1796 75E7              ;	jsr	DerefB
1797 75E7
1798 75E7              * If Op = Diff and RgnB is empty, copy RgnA into DstRgn
1799 75E7
1800 75E7 A9 02 00              lda   #2                       ; get Diff opcode
1801 75EA C5 BA                 cmp   Op                       ; is it Diff?
1802 75EC 90 5B                 bcc   UniXor                   ; if Op > Diff then Union or Xor
1803 75EE D0 0D                 bne   BBoxes                   ; if Op <> Diff, it's Sect
1804 75F0
1805 75F0              * Op = Diff, so check RgnB for empty
1806 75F0
1807 75F0 4B F4 FA 78           ROMCALL RgnBEmpty              ; is RgnB empty
1808 75FB 10 BD                 bpl   Copy                     ; if it's empty, CopyRgnA
1809 75FD
1810 75FD              * If Op = Sect or Diff, then intersect the bounding boxes.
1811 75FD
1812 75FD 4B F4 07 79  BBoxes   ROMCALL RgnSector              ; RgnY1..RgnX2 := RgnA * RgnB
1813 7608
1814 7608 A5 B0                 lda   RgnX1
1815 760A C5 B4                 cmp   RgnX2                    ; compare to X2
1816 760C 10 06                 bpl   Empty                    ; if X1=X2, it's empty
1817 760E A5 AE                 lda   RgnY1                    ; get top
1818 7610 C5 B2                 cmp   RgnY2                    ; if Y1 >= Y2, it's empty
1819 7612 30 07                 bmi   NotEmpty                 ; so do it
1820 7614
1821 7614              * The bounding boxes don't intersect.  If Op = Sect, then return empty.
1822 7614              * If Op = Diff, then copy RgnA into DstRgn
1823 7614
1824 7614 A5 BA        Empty    lda   Op                       ; get op
1825 7616 F0 BA                 beq   Zero                     ; if Sect, return empty
1826 7618 4C BA 78              jmp   Copy                     ; no, copy SrcA into DstRgn
1827 761B
1828 761B              * If Op = Sect, then check for both inputs rectangular
1829 761B
1830 761B A5 BA        NotEmpty lda   Op                       ; is op = Sect
1831 761D D0 6E                 bne   NotEasy                  ; no, continue
1832 761F A9 0A 00              lda   #10                      ; get rectangular region size
1833 7622 C7 54                 cmp   [RgnPtrA]                ; compare with RgnA length
1834 7624 D0 67                 bne   NotEasy                  ; no, continue
1835 7626 C7 64                 cmp   [RgnPtrB]                ; compare with RgnB length
1836 7628 D0 63                 bne   NotEasy                  ; no, continue
1837 762A
1838 762A              * push dstrgn and address of temprect.  Could be bad news.
1839 762A
1840 762A A3 0B                 lda   DstRgn+2,s               ; get high word
1841 762C 48                    pha                            ; push it
1842 762D A3 0B                 lda   DstRgn+2,s               ; get low word
1843 762F 48                    pha                            ; push it
1844 7630 18                    clc   
1845 7631 A9 00 00              lda   #0                       ; it's in bank 0
1846 7634 48                    pha                            ; push high word
1847 7635 7B                    tdc                            ; get direct register
1848 7636 69 AE 00              adc   #RgnY1                   ; add in offset
1849 7639 48                    pha                            ; push low word
1850 763A A2 04 6C 22           _RectRgn                       ; RectRgn(dstRgn,tempRect)
1851 7641 B0 03                 bcs   T2
1852 7643 82 35 00              brl   DoUnlockABNoErr
1853 7646
1854 7646 82 3B 00     T2       brl   DoUnlockABError
1855 7649
1856 7649 4B F4 53 79  UniXor   ROMCALL RgnBEmpty              ; is RgnB empty?
1857 7654 30 03                 bmi   T3                       ; yes, copy RgnA
1858 7656 82 61 FF              brl   Copy
1859 7659 4B F4 63 79  T3       ROMCALL RgnAEmpty              ; is RgnA empty?
1860 7664 30 27                 bmi   NotEasy                  ; yes, copy RgnB
1861 7666 A3 0F                 lda   SrcRgnB+2,s              ; get high word
1862 7668 48                    pha                            ; push it
1863 7669 A3 0F                 lda   SrcRgnB+2,s              ; get low word
1864 766B 48                    pha                            ; push it
1865 766C A3 0F                 lda   DstRgn+6,s               ; get high word
1866 766E 48                    pha                            ; push it
1867 766F A3 0F                 lda   DstRgn+6,s               ; get low word
1868 7671 48                    pha                            ; push it
1869 7672 A2 04 69 22           _CopyRgn                       ; copy it
1870 7679 B0 09                 bcs   DoUnlockABError
1871 767B DA           DoUnlockABNoErr phx   
1872 767C 20 DB 79              jsr   UnlockAB
1873 767F FA                    plx   
1874 7680 5C 71 FC FE           JML   BusyEC12
1875 7684
1876 7684 48           DoUnlockABError pha   
1877 7685 20 DB 79              jsr   UnlockAB
1878 7688 FA                    plx   
1879 7689 5C 74 FC FE           JML   BusyErr12
1880 768D
1881 768D 18           NotEasy  clc                            ; clear carry for addition
1882 768E A7 54                 lda   [RgnPtrA]                ; get RgnA length
1883 7690 67 64                 adc   [RgnPtrB]                ; add RgnB length
1884 7692 0A                    asl   A                        ; double (Quickdraw did ADD D4,D4)
1885 7693 85 C4                 sta   PtCount                  ; save it
1886 7695
1887 7695              * We've taken all the shortcuts we can.  Now we pass the buck to RgnOp to do
1888 7695              * the real work.  The source regions are still in RgnHandleA and RgnHandleB.
1889 7695              * PtCount contains the maximum size we should need.  Load X with 0 since we
1890 7695              * have no horizontal offset to worry about (just for cleanliness).
1891 7695
1892 7695 A2 00 00              ldx   #0                       ; unnecessary unless code changes
1893 7698 22 98 1F E0           jsl   RgnOp                    ; do it
1894 769C B0 21                 bcs   RgnOpError               ; RgnOp propogates errors
1895 769E A3 09                 lda   DstRgn,s
1896 76A0 85 50                 sta   RgnHandleA
1897 76A2 A3 0B                 lda   DstRgn+2,s
1898 76A4 85 52                 sta   RgnHandleA+2
1899 76A6 20 FD 79              jsr   DerefA                   ; nice shortcut...
1900 76A9 22 94 1F E0           jsl   PackRgn                  ; call it
1901 76AD
1902 76AD A5 BE 48 A5           PushLong BufHandle             ; push handle
1903 76B3 A2 02 10 22           _DisposeHandle                 ; dispose of point buffer handle
1904 76BA B0 C8                 bcs   DoUnlockABError
1905 76BC 82 BC FF              brl   DoUnlockABNoErr
1906 76BF
1907 76BF 48           RgnOpError pha                          ; save error code
1908 76C0
1909 76C0 A5 BC                 lda   BufHandle
1910 76C2 05 BE                 ora   BufHandle+2
1911 76C4 F0 0D                 beq   DontDispose
1912 76C6 A5 BE 48 A5           PushLong BufHandle 
1913 76CC A2 02 10 22           _DisposeHandle 
1914 76D3 20 DB 79     DontDispose jsr   UnlockAB
1915 76D6 FA                    plx                            ; get error code back
1916 76D7 5C 74 FC FE           jmp   BusyErr12
1917 76DB
1918 76DB              UnlockAB  
1919 76DB              ; modified this routine to unblock the src rgns on the stack instead
1920 76DB              ; first save the direct page...
1921 76DB 0B                    phd   
1922 76DC FA                    plx                            ; in the <X> register...
1923 76DD 3B                    tsc                            ; and make the stack a direct page
1924 76DE 5B                    tcd   
1925 76DF A0 04 00              ldy   #4                       ; offset to the handle attributes
1926 76E2 B7 15                 lda   [SrcRgnA+4],y            ; unlock A (account for error and jsr)
1927 76E4 29 FF 7F              and   #$7FFF
1928 76E7 97 15                 sta   [SrcRgnA+4],y
1929 76E9 B7 11                 lda   [SrcRgnB+4],y            ; unlock B
1930 76EB 29 FF 7F              and   #$7FFF
1931 76EE 97 11                 sta   [SrcRgnB+4],y
1932 76F0 DA                    phx                            ; restore direct page
1933 76F1 2B                    pld                            ; to what it was before...
1934 76F2 60                    rts   
1935 76F3
1936 76F3              DeRefAB   
1937 76F3 A0 04 00              ldy   #4                       ; lock it
1938 76F6 B7 60                 lda   [RgnHandleB],y
1939 76F8 09 00 80              ora   #$8000
1940 76FB 97 60                 sta   [RgnHandleB],y
1941 76FD              DerefA    
1942 76FD A0 04 00              ldy   #4                       ; lock it
1943 7700 B7 50                 lda   [RgnHandleA],y
1944 7702 09 00 80              ora   #$8000
1945 7705 97 50                 sta   [RgnHandleA],y
1946 7707
1947 7707 A7 50                 lda   [RgnHandleA]             ; deref it.
1948 7709 85 54                 sta   RgnPtrA
1949 770B A7 60                 lda   [RgnHandleB]             ; deref it.
1950 770D 85 64                 sta   RgnPtrB
1951 770F A0 02 00              ldy   #2
1952 7712 B7 50                 lda   [RgnHandleA],y
1953 7714 85 56                 sta   RgnPtrA+2
1954 7716 B7 60                 lda   [RgnHandleB],y
1955 7718 85 66                 sta   RgnPtrB+2
1956 771A 60                    rts   
1957 771B
1958 771B                       ENDP 
1959 771B
1960 771B              LOCALQDStart proc Export 
1961 771B
1962 771B 48                    pha   
1963 771C AF FF 00 E1           lda   >BusyFlag
1964 7720 1A                    inc   a
1965 7721 8F FF 00 E1           sta   >BusyFlag
1966 7725 68                    pla   
1967 7726 0B                    phd                            ; push d on stack
1968 7727 5B                    tcd                            ; set d
1969 7728 A3 03                 lda   3,s                      ; getorig rts
1970 772A 48                    pha                            ; put on stack
1971 772B A3 03                 lda   3,s                      ; move orig d to on top of rts
1972 772D 83 05                 sta   5,s
1973 772F 68                    pla                            ; pull rts off stack
1974 7730 83 01                 sta   1,s                      ; put over orig d
1975 7732 7B                    tdc                            ; get QD D back in a
1976 7733 60                    rts                            ; done
1977 7734                       EndP 
1978 7734
1979 7734
1980 7734              *******************************************************
1981 7734              *
1982 7734              * InflateTextBuffer (patched 27-Nov-91 DAL)
1983 7734              *
1984 7734              * (Original is in QD:Text.asm.)
1985 7734              *
1986 7734              *******************************************************
1987 7734              MyInflateTextBuffer PROC export 
1988 7734
1989 7734              OrigDirect equ   1
1990 7734              RTL1     equ   OrigDirect+2
1991 7734              RTL2     equ   RTL1+3
1992 7734              newHeight equ   RTL2+3
1993 7734              newWidth equ   newHeight+2
1994 7734
1995 7734 20 1B 7A              jsr   LocalQDStart
1996 7737
1997 7737 A3 0B                 lda   newWidth,s
1998 7739 85 56                 sta   newFontWidth
1999 773B A3 09                 lda   newHeight,s
2000 773D 85 50                 sta   newTBHeight
2001 773F
2002 773F              *** added 3-Dec-91 DAL -- preserve old DP values that we may need to restore
2003 773F A2 00 01              ldx   #256
2004 7742 B5 04                 lda   <fontWidth,x
2005 7744 48                    pha   
2006 7745 D4 4A                 pei   <textBufHeight
2007 7747 D4 48                 pei   <textBufRowWords
2008 7749              *** end 3-Dec-91
2009 7749
2010 7749 22 41 87 FE           jsl   $fe8741                  ;InflateTB (ROM 3)
2011 774D
2012 774D              ;;;	ldy	#4
2013 774D              ;;;	jmp	BusyEC
2014 774D              *** added 3-Dec-91 DAL -- honor error code from InflateTB, and restore
2015 774D              ***  DP values if we had an error (even though QD doesn't mess up the
2016 774D              ***  values if it can't resize the buffer, we do mess them up if QD Aux
2017 774D              ***  can't resize -its- buffers).
2018 774D A8                    tay                            ;error code to Y
2019 774E
2020 774E 68                    pla   
2021 774F 90 02                 bcc   @noStore1
2022 7751 85 48                 sta   <textBufRowWords
2023 7753 68           @noStore1 pla   
2024 7754 90 02                 bcc   @noStore2
2025 7756 85 4A                 sta   <textBufHeight
2026 7758 68           @noStore2 pla   
2027 7759 90 05                 bcc   @noStore3
2028 775B A2 00 01              ldx   #256
2029 775E 95 04                 sta   <fontWidth,x
2030 7760              @noStore3  
2031 7760 BB                    tyx                            ;error code to X
2032 7761 2B                    pld   
2033 7762 A0 04 00              ldy   #4
2034 7765 5C 80 01 E1           jml   $e10180                  ;ToBusyStrip
2035 7769              *** end 3-Dec-91
2036 7769
2037 7769              *******************************************************
2038 7769              *
2039 7769              * $DA04 Get640Colors():PatternTablePtr
2040 7769              *                      LONG
2041 7769              *
2042 7769              * Returns a pointer to a table of all the solid 640-
2043 7769              * mode dithered patterns (32 bytes of $00, 32 bytes of
2044 7769              * $11, ..., 32 bytes of $ff).
2045 7769              *
2046 7769              * New call 24-Sep-90 DAL for System Software 6.0
2047 7769              *
2048 7769              *******************************************************
2049 7769              Get640Colors PROC export 
2050 7769
2051 7769              SolidColors equ   $fd40f6
2052 7769
2053 7769 A9 FD 00              lda   #^SolidColors
2054 776C 83 09                 sta   9,s
2055 776E A9 F6 40              lda   #<SolidColors
2056 7771 83 07                 sta   7,s
2057 7773 A9 00 00              lda   #0
2058 7776 18                    clc   
2059 7777 6B                    rtl   
2060 7778
2061 7778                       EndP 
2062 7778
2063 7778              *******************************************************
2064 7778              *
2065 7778              * $DB04  Set640Color(color)
2066 7778              *                    WORD
2067 7778              *
2068 7778              * New call 24-Sep-90 DAL for System Software 6.0
2069 7778              *
2070 7778              *******************************************************
2071 7778              Set640Color PROC export 
2072 7778
2073 7778              SolidColors equ   $fd40f6
2074 7778
2075 7778 A3 07                 lda   7,s                      ;input color number
2076 777A 29 0F 00              and   #$000f
2077 777D EB                    xba   
2078 777E 4A                    lsr   a
2079 777F 4A                    lsr   a
2080 7780 4A                    lsr   a
2081 7781 69 F6 40              adc   #<SolidColors            ;carry is guaranteed clear
2082 7784
2083 7784 F4 FD 00              pea   SolidColors>>16
2084 7787 48                    pha   
2085 7788 A2 04 30 22           _SetPenPat 
2086 778F AA                    tax                            ;error code
2087 7790 A0 02 00              ldy   #2                       ;strip 2 bytes
2088 7793 5C 84 01 E1           jml   $e10184                  ;ToStrip
2089 7797
2090 7797                       EndP 
2091 7797
2092 7797              ;*******************************************************
2093 7797              ;*
2094 7797              ;* $DC04  GetScanlineAddr(lineNum):@address
2095 7797              ;*                        WORD     PTR
2096 7797              ;*
2097 7797              ;* New call 22-Oct-90 DAL for System Software 6.0
2098 7797              ;*
2099 7797              ;*******************************************************
2100 7797              ;GetScanlineAddr	proc export
2101 7797              ;
2102 7797              ;	ldx	#$0452	;anticipate badScanLine error
2103 7797              ;	lda	7,s
2104 7797              ;	cmp	#200
2105 7797              ;	bcs	@error
2106 7797              ;
2107 7797              ;	ldx	#$00e1	;anticipate bank $E1 (no shadowing)
2108 7797              ;	lda	>$E0C035	;shadow
2109 7797              ;	and	#$0008
2110 7797              ;	bne	@bank
2111 7797              ;	ldx	#$0001	;SHR shadowing
2112 7797              ;@bank	txa
2113 7797              ;	sta	11,s
2114 7797              ;
2115 7797              ;	lda	7,s
2116 7797              ;	asl	a
2117 7797              ;	tax
2118 7797              ;	lda	>$fe553c,x
2119 7797              ;	sta	9,s
2120 7797              ;
2121 7797              ;	ldx	#0
2122 7797              ;@error	ldy	#2	;strip 2 bytes
2123 7797              ;	jml	$e10184	;ToStrip
2124 7797              ;
2125 7797              ;	endp
2126 7797
2127 7797                       END   
